#include <stdio.h>
#include <stdarg.h>
#include <fcntl.h>
#include <errno.h>
#include <stdlib.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/time.h>
#include <sys/ioctl.h>
#include <sys/types.h>
#include <sys/select.h>
#include <sys/socket.h>
#include <sys/sysinfo.h>
#include <netinet/in.h>
#include <net/if.h>
//#include <linux/ipv6.h>
#include <netinet/icmp6.h>
#include <linux/sockios.h>
#include <arpa/inet.h>

#include "tp_ctl.h"


//#define Print(fmt, args ...) fprintf(stderr, "tp_ctl[%s,%d]: "fmt"\n", __func__, __LINE__, ## args)
#define Print(fmt, args ...) //PRINTF_ECHO("tp_ctl[%s,%d]: "fmt"\n", __func__, __LINE__, ## args)

extern void client6_reload();

static unsigned char uniqueAddr[IPV6_ADDR_LEN] = {0xFD, 0x00, 0x00, 0xb0, 0x00, 0x52};
static unsigned char linkLocalAddr[IPV6_ADDR_LEN] = {0xFE, 0x80};
static unsigned char nullAddr[IPV6_ADDR_LEN] = {0};
static char *ifname = NULL;
static char *conffile;

void PRINTF_ECHO(char *cmd, ...)
{
        char    buf[2048] = {0};
        char    buf1[2048] = {0};
        va_list vaList;

        va_start(vaList, cmd);
        vsprintf(buf, cmd, vaList);
        va_end(vaList);
       
        snprintf(buf1,sizeof(buf1),"echo \"%s\" > /dev/console \r\n",buf);
        system(buf1);
}

void printIPv6(const char *str, int line, unsigned char * addr)
{
	int i;
	char tmp[200] = {0};
	char ch = ' ';
	sprintf(tmp, "%s(%d):\n", str, line);
	for (i = 0; i < 8; i ++)
	{
		sprintf(tmp + strlen(tmp), "%c%02x%02x", ch, addr[2 * i], addr[2 * i + 1]);
		ch = ':';
	}
	Print("%s", tmp);
}

static int setUniqueAddr()
{
	struct in6_ifreq ifr6;
	int index;
	int sockfd6;
	char str[100];
	int i = 0;

	index = if_nametoindex(ifname);
	if (0 == index)
	{
		Print("get index err: %s", strerror(errno));
		exit(1);
	}
	sockfd6 = socket(AF_INET6, SOCK_DGRAM, 0);

	memcpy(&ifr6.ifr6_addr, uniqueAddr, IPV6_ADDR_LEN);
	ifr6.ifr6_prefixlen = 64;
	ifr6.ifr6_ifindex = index;
	if (ioctl(sockfd6, SIOCSIFADDR, &ifr6) < 0)
	{
		Print("set local unique addr: %s", strerror(errno));
		exit(1);
	}

	close(sockfd6);
	return 1;
}

static void gen_unique_addr()
{
	struct ifreq ifr;
	unsigned char *mac;
	int sock;
	int i = 8;
	
	if ((sock = socket(AF_INET, SOCK_STREAM, 0)) < 0)
	{
		Print("socket: %s", strerror(errno));
		return;
	}

	strcpy(ifr.ifr_name, ifname);
	if (ioctl(sock, SIOCGIFHWADDR, &ifr) < 0)
	{
		Print("ioctl: %s", strerror(errno));
		return;
	}

	mac = ifr.ifr_hwaddr.sa_data;
	uniqueAddr[8] = (mac[0] & 0x2) ? (mac[0] & 0xFD) : (mac[0] | 0x2);
	memcpy(uniqueAddr + 9, mac + 1, 2);
	uniqueAddr[11] = 0xFF;
	uniqueAddr[12] = 0xFE;
	memcpy(uniqueAddr + 13, mac + 3, 3);
	
	close(sock);
}
	

static void getLocalAddr6()
{
        unsigned char addr[IPV6_ADDR_LEN];
        char devname[20];
        int if_idx, dad_status, scope, plen, prelen;
	int hasUniqueAddr = 0;
	int unique = 0;
        char addr6p[8][5];
        char addrStr[40];
        FILE *f;

        if (NULL == (f = fopen(PATH_PROCNET_IFNET6, "r")))
	{
		Print("open %s err: %s", PATH_PROCNET_IFNET6, strerror(errno));
		return;
	}

	Print("get proc IPv6:");
	system ("cat /proc/net/if_inet6 > /dev/console");

	gen_unique_addr();

        while (EOF != fscanf(f, "%4s%4s%4s%4s%4s%4s%4s%4s %02x %02x %02x %02x %20s\n",
                addr6p[0], addr6p[1], addr6p[2], addr6p[3],
                addr6p[4], addr6p[5], addr6p[6], addr6p[7],
                &if_idx, &plen, &scope, &dad_status, devname))
        {
                if (strcmp(devname, ifname))
                {
                        continue;
                }

                sprintf(addrStr, "%s:%s:%s:%s:%s:%s:%s:%s",
                        addr6p[0], addr6p[1], addr6p[2], addr6p[3],
                        addr6p[4], addr6p[5], addr6p[6], addr6p[7]);
                inet_pton(AF_INET6, addrStr, addr);
		
		printIPv6("get proc IPv6", __LINE__, addr);

                if (!memcmp(addr, linkLocalAddr, 8))
                {
			memcpy(linkLocalAddr, addr, IPV6_ADDR_LEN);
                	printIPv6("get link local addr", __LINE__, linkLocalAddr);
                        continue;
                }

		if (!memcmp(addr, uniqueAddr, IPV6_ADDR_LEN))
		{
			printIPv6("get unique local addr", __LINE__, addr);
			hasUniqueAddr = 1;
		}
        }

	/*if has no Unique addr, set one*/
	if (!hasUniqueAddr)
	{
		setUniqueAddr();
	}
}

static void checkIPv6Confilit(struct localAddr *laddr)
{
        int i,j;
        int nbyte, nbit;

        for (i = 0 ;i < laddr->num - 1; i++)
        {
                int iplen = laddr->addr[i].prelen;
                unsigned char iaddr[IPV6_ADDR_LEN];
                memset(iaddr, 0, IPV6_ADDR_LEN);

                if (!memcmp(laddr->addr[i].addr, nullAddr, IPV6_ADDR_LEN))
                {
                        continue;
                }

                nbyte = iplen / 8;
                nbit = iplen % 8;
                memcpy(iaddr, laddr->addr[i].addr, nbyte);
                if (IPV6_ADDR_LEN > nbyte)
                {
                        iaddr[nbyte] = laddr->addr[i].addr[nbyte] & (0xFF << (8 - nbit));
                }

                for (j = i + 1; j < laddr->num; j ++)
                {
                        int jplen = laddr->addr[j].prelen;
                        unsigned char jaddr[IPV6_ADDR_LEN];
                        memset(jaddr, 0, IPV6_ADDR_LEN);

                        if (jplen != iplen)
                        {
                                continue;
                        }

                        if (!memcmp(laddr->addr[j].addr, nullAddr, IPV6_ADDR_LEN))
                        {
                                continue;
                        }

                        nbyte = jplen / 8;
                        nbit = jplen % 8;
                        memcpy(jaddr, laddr->addr[j].addr, nbyte);
                        if (IPV6_ADDR_LEN > nbyte)
                        {
                                jaddr[nbyte] = laddr->addr[i].addr[nbyte] & (0xFF << (8 - nbit));
                        }

                        if (!memcmp(iaddr, jaddr, IPV6_ADDR_LEN))
                        {
                                memset(laddr->addr[j].addr, 0, IPV6_ADDR_LEN);
                        }
                }
        }
}

static int open_icmp6_socket()
{
	int sockfd;
	int val;
	int flags;
	struct icmp6_filter filter;

	sockfd = socket(AF_INET6, SOCK_RAW, IPPROTO_ICMPV6);
	if (sockfd < 0)
	{
		Print("create ICMPV6 socket err: %s", strerror(errno));
		return -1;
	}
	
/*	val = 2;
	if (setsockopt(sockfd, IPPROTO_IPV6, IPV6_CHECKSUM, &val, sizeof(int)) < 0)
	{
		Print("setsockopt IPV6_CHECKSUM err: %s", strerror(errno));
		return -1;
	}*/

	val = 1;
#ifdef IPV6_RECVPKTINFO
	if (setsockopt(sockfd, IPPROTO_IPV6, IPV6_RECVPKTINFO, &val, sizeof(int)) < 0)
	{
		Print("setsockopt(IPV6_RECVPKTINFO): %s", strerror(errno));
		return -1;
	}
#else
	if (setsockopt(sockfd, IPPROTO_IPV6, IPV6_PKTINFO, &val, sizeof(int)) < 0)
	{
		Print("setsockopt(IPV6_PKTINFO): %s", strerror(errno));
		return -1;
	}
#endif

	ICMP6_FILTER_SETBLOCKALL(&filter);
//	ICMP6_FILTER_SETPASS(ND_ROUTER_SOLICIT, &filter);
	ICMP6_FILTER_SETPASS(ND_ROUTER_ADVERT, &filter);

	if (setsockopt(sockfd, IPPROTO_ICMPV6, ICMP6_FILTER, &filter, sizeof(filter)) < 0)
	{
		Print("setsockopt ICMPV6_FILTER err: %s", strerror(errno));
		return -1;
	}

	flags = fcntl(sockfd, F_GETFL, 0);
	fcntl(sockfd, F_SETFL, flags | O_NONBLOCK);

	return sockfd;
}

static int rcv_icmp6_packet(int sockfd, unsigned char *msg, struct sockaddr_in6 *addr)
{
	struct iovec iov;
	iov.iov_len = MSG_SIZE_RCV;
	iov.iov_base = (void *)msg;

	struct msghdr mhdr;
	memset(&mhdr, 0, sizeof(mhdr));
	mhdr.msg_name = (void *)addr;
	mhdr.msg_namelen = sizeof(*addr);
	mhdr.msg_iov = &iov;
	mhdr.msg_iovlen = 1;
	mhdr.msg_control = NULL;
	
	int len = recvmsg(sockfd, &mhdr, 0);

	if (len < 0)
	{
		Print("recvmsg: %s", strerror(errno));
		return len;
	}

	Print("msg_namelen = %d", mhdr.msg_namelen);
	
	return len;
}

static void clean_sock_cache(int sock)
{
	unsigned char msg[MSG_SIZE_RCV];
	struct sockaddr_in6 rcv_addr;

	Print("going to clean sock cache");
	while (rcv_icmp6_packet(sock, msg, &rcv_addr) > 0);
}

static int isLocalAddr(unsigned char *src_addr, struct localAddr *laddr)
{
	int i;

	for (i = 0; i < laddr->num; i++)
	{
		if (!memcmp(src_addr, laddr->addr[i].addr, IPV6_ADDR_LEN))
		{
			return 1;
		}
	}

	return 0;
}

static long get_sysup_time(void)
{
        struct sysinfo info;
        memset(&info, 0, sizeof(info));
        sysinfo(&info);
        return info.uptime;
}

static restartPort()
{
#ifdef RPT_PLATFORM_MTK
        char cmd_str[64] = {0};
        int port_num;
        /* now we only have port 1,2,3 */
        for(port_num = 1; port_num <= 3; port_num++)
        {
                sprintf(cmd_str, "mii_mgr -s -p %d -r 0 -v 3900", port_num);//down mtk
                system(cmd_str);
        }

        for(port_num = 1; port_num <= 3; port_num++)
        {
                sprintf(cmd_str, "mii_mgr -s -p %d -r 0 -v 3300", port_num);//down mtk
                system(cmd_str);
        }
#endif	
}

static void reconnectCli()
{
	static int is_wifi_started = 0;

	Print("going to disconnect client");

        /* to avoid wifid from changing params too early 
         * 100s after bootup should be enough
         */
	if (0 == is_wifi_started)
	{
                if (get_sysup_time() < 60)
                {
                        Print("too early : %ld...\n", get_sysup_time());
                        return;
                }
                else
                {
                        is_wifi_started = 1;
                        Print("wifid must have been started : %ld...\n", get_sysup_time());
                }
        }

	restartPort();
	system("wifi disconnsta");
}

/**************************************************
*function	runRadvd
*discreption	kill dhcp6c, restart radvd and dhcp6s
***************************************************/
static void runRadvd()
{
	int rafd, dhfd;
	int prelen;
	char addrStr[40];
	char addrStart[40];
	char addrEnd[40];
	char prefixStr[40];
	char tmpStr[500];
	char cmdStr[100];
	unsigned char addrLocal[IPV6_ADDR_LEN];

	Print("going to kill radvd and dhcp6s");
	system("killall radvd");
	system("killall dhcp6s");

	reconnectCli();

	rafd = open(RADVD_CONFIG_FILE_PATH, O_WRONLY | O_TRUNC | O_CREAT, 0666);
	dhfd = open(DHCP6S_CONFIG_FILE_PATH, O_WRONLY | O_TRUNC | O_CREAT, 0666);
	if (rafd <= 0 || dhfd <= 0)
	{
		Print("open file failed");
		return;
	}

	prelen = 64;
	memcpy(addrLocal, uniqueAddr, IPV6_ADDR_LEN);

	if (NULL == inet_ntop(AF_INET6, addrLocal, addrStr, 40))
	{	
		printIPv6("get addr str err", __LINE__, addrLocal);
		return;
	}

	addrLocal[14] = 0x10;
	addrLocal[15] = 0x00;
	if (NULL == inet_ntop(AF_INET6, addrLocal, addrStart, 40))
	{
		printIPv6("get addr str err", __LINE__, addrLocal);
		return;
	}

	addrLocal[14] = 0x20;
	addrLocal[15] = 0x00;
	if (NULL == inet_ntop(AF_INET6, addrLocal, addrEnd, 40))
	{
		printIPv6("get addr str err", __LINE__, addrLocal);
		return;
	}

	memset(addrLocal + 8, 0, 8);
	if (NULL == inet_ntop(AF_INET6, addrLocal, prefixStr, 40))
	{
		printIPv6("get addr str err", __LINE__, addrLocal);
		return;
	}
	
	sprintf(tmpStr, 
	"interface %s {\n"
	"	AdvSendAdvert on;\n\n"
	"	MinRtrAdvInterval 80;\n"
	"	MaxRtrAdvInterval 120;\n\n"
	"	AdvDefaultPreference low;\n"
	"	AdvManagedFlag off;\n"
	"	AdvOtherConfigFlag on;\n\n"
	"	prefix %s/%d {\n"
	"		AdvOnLink on;\n"
	"		AdvAutonomous on;\n"
	"		AdvRouterAddr on;\n"
	"		AdvPreferredLifetime 900;\n"
	"		AdvValidLifetime 86400;\n"
	"	};\n"
	"};\n", ifname, prefixStr, prelen);
	write(rafd, tmpStr, strlen(tmpStr));

	sprintf(tmpStr, 
	"option domain-name-servers %s;\n"
	"option refreshtime 600;\n", addrStr);
	write(dhfd, tmpStr, strlen(tmpStr));

	close(dhfd);
	close(rafd);

	sprintf(cmdStr, "dhcp6s -c %s %s", DHCP6S_CONFIG_FILE_PATH, ifname);
	Print("system:%s", cmdStr);
	system(cmdStr);
	sprintf(cmdStr, "radvd -C %s %s -p %s", RADVD_CONFIG_FILE_PATH, ifname, RADVD_PID_FILE_PATH);
	Print("system:%s", cmdStr);
	system(cmdStr);
}

/**************************************************
*function	stopRadvd
*discreption	kill radvd and dhcp6s, restart dhcp6c
***************************************************/
static void stopRadvd(struct nd_router_advert *pRA)
{
	int dhfd;
	unsigned char flag = pRA->nd_ra_flags_reserved;
	int mEnabled = flag & ND_RA_FLAG_MANAGED;
	int oEnabled = flag & ND_RA_FLAG_OTHER;
	char tmpStr[500];
	char cmdStr[100];

	Print("going to kill radvd and dhcp6s");
	system("killall radvd");
	system("killall dhcp6s");
	

	reconnectCli();

	dhfd = open(conffile, O_WRONLY | O_TRUNC | O_CREAT, 0666);
	if (dhfd < 0)
	{
		Print("open %s failed: %s", conffile, strerror(errno));
		return;
	}

	if (1 == mEnabled)
	{
		sprintf(tmpStr, 
		"interface %s {\n"	
		"	send ia-na 100;\n"
		"};\n\n"
		"id-assoc na 100 { };\n"
		"#careful script not implememt\n", ifname);
	} else
	{
		sprintf(tmpStr, 
		"interface %s {\n"
		"	information-only;\n"
		"};\n"
		"#careful script not implement\n", ifname);
	}
	write(dhfd, tmpStr, strlen(tmpStr));
	close(dhfd);
	
	Print("reload client");
	client6_reload();
}

static void getLocalMac(unsigned char *mac)
{
	static int runFirstFlag = 1;
	int sockfd;
	struct ifreq ifr;

	memset(mac, 0, 6);
	sockfd = socket(AF_INET, SOCK_STREAM, 0);
	if (sockfd < 0)
	{
		Print("create socket failed: %s", strerror(errno));
		return;
	}

	memset(&ifr, 0, sizeof(struct ifreq));
	strncpy(ifr.ifr_name, ifname, sizeof(ifr.ifr_name) - 1);
	if (ioctl(sockfd, SIOCGIFHWADDR, &ifr) < 0)
	{
		Print("mac ioctl error: %s", strerror(errno));
		return;
	}

	memcpy(mac, ifr.ifr_hwaddr.sa_data, 6);
}

static int open_rs_sock()
{
	int sock;
	int val;
	unsigned int onoff;

	sock = socket(AF_INET6, SOCK_RAW, IPPROTO_ICMPV6);
	if (sock < 0)
	{
		Print( "can't create socket(AF_INET6): %s", strerror(errno));
		return -1;
	}

	val = 255;
	if (setsockopt(sock, IPPROTO_IPV6, IPV6_MULTICAST_HOPS, &val, sizeof(val)) < 0)
	{
		Print("set IPV6_MULTICAST_HOPS err: %s", strerror(errno));
		return -1;
	}

	onoff = 0;
	if (setsockopt(sock, IPPROTO_IPV6, IPV6_MULTICAST_LOOP, &onoff, sizeof(onoff)) < 0)
	{
		Print("set IPV6_MULTICAST_LOOP err: %s", strerror(errno));
		return -1;
	}

	return sock;
}

static int send_rs_pack(int sock)
{
	int len = 0;
	int ret;
	unsigned char buff[1000];
	unsigned char mac[6];
	unsigned char all_routers_addr[] = {0xff, 0x02, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2};
	struct sockaddr_in6 addr;
	struct nd_router_solicit *rs_hdr;
	struct nd_opt_hdr *opt_hdr;

	memset((void *)&addr, 0, sizeof(addr));
	addr.sin6_family = AF_INET6;
	addr.sin6_port = htons(IPPROTO_ICMPV6);
	memcpy(&addr.sin6_addr, all_routers_addr, sizeof(struct in6_addr));

	memset(buff, 0, sizeof(buff));

	rs_hdr = (struct nd_router_solicit *)(buff + len);
	rs_hdr->nd_rs_hdr.icmp6_type =  133;
	rs_hdr->nd_rs_hdr.icmp6_code = 0;
	rs_hdr->nd_rs_hdr.icmp6_cksum = htons(0);
	rs_hdr->nd_rs_hdr.icmp6_dataun.icmp6_un_data32[0] = 0;
	len += sizeof(struct nd_router_solicit);

	opt_hdr = (struct nd_opt_hdr *)(buff + len);
	opt_hdr->nd_opt_type = 0x01;
	opt_hdr->nd_opt_len = 0x01;
	len += sizeof(struct nd_opt_hdr);

	getLocalMac(mac);
	memcpy(buff + len, mac, sizeof(mac));
	len += sizeof(mac);
	
	ret = sendto(sock, buff, len, 0, (struct sockaddr *)&addr, sizeof(addr));

	Print("len = %d", len);
	Print("sendto result: %d", ret);

	return 0;
}

void *tp_ctl(void *arg)
{
	int sock;
	int sock_rs;
	int timeout = 1;
	int res;
	int isLocalRaRun = 0;
	fd_set fds;
	struct timeval tv;
	struct msghdr mhdr;
	
	ifname = ((struct ctl_para *)arg)->ifname;
	conffile = ((struct ctl_para *)arg)->conffile;

	sock = open_icmp6_socket();
	if (sock < 0)
	{
		exit(1);
	}

	sock_rs = open_rs_sock();
	if (sock_rs < 0)
	{
		exit(1);
	}

	getLocalAddr6();

	while (1)
	{
		unsigned char linkLocalPre[IPV6_ADDR_LEN] = {0xFE, 0x80};
		unsigned char msg[MSG_SIZE_RCV];
		struct nd_router_advert *pRA = (struct nd_router_advert *)msg;
		struct sockaddr_in6 rcv_addr;
		int flag;
		int len;
		int i;

		if (!memcmp(linkLocalPre, linkLocalAddr, IPV6_ADDR_LEN))
		{
			sleep(30);
			getLocalAddr6();
		}

		clean_sock_cache(sock);
		send_rs_pack(sock_rs);

		flag = 0;
		for (i = 0; i < 5; i ++)
		{
			FD_ZERO(&fds);
			FD_SET(sock, &fds);
	
			tv.tv_sec = 20;
			tv.tv_usec = 0;
			res = select(sock + 1, &fds, NULL, NULL, &tv);
	
			if (-1 == res)
			{
				Print("select err: %s", strerror(errno));
				break;
			}
	
			if (!res)
			{
				Print("select timeout");
				break;
			}

			len = rcv_icmp6_packet(sock, msg, &rcv_addr);
			if (len < 0)
			{
				continue;
			}

			if (!memcmp(rcv_addr.sin6_addr.s6_addr, linkLocalAddr, IPV6_ADDR_LEN))
			{
				Print("recved my own packet");
				continue;
			}

			if (ND_ROUTER_ADVERT != pRA->nd_ra_hdr.icmp6_type)
			{
				Print("not RA packet");
				continue;
			}

			flag = 1;
			break;
		}
		Print("flag = %d", flag);
		Print("isLocalRaRun = %d", isLocalRaRun);
		/*recved RA packet*/
		if (flag)
		{
			if (1 == isLocalRaRun)
			{
				stopRadvd(pRA);
				isLocalRaRun = 0;
			}
			timeout = 1;
		}
		else
		{
			Print("timeout = %d", timeout);
			if (0 == isLocalRaRun)
			{
				if (timeout > 0)
				{
					timeout --;
				}
				else
				{
					Print("going to run radvd");
					runRadvd();
					isLocalRaRun = 1;
				}
			}		
		}
					
		sleep(30);
	}
	return NULL;
}
